require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Tracking"

ST.addContributor(KEY, function(ctx)
    local lvl = ctx.getLevel()

    ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))

    ---------------------------------------------------------
    -- 1) Inspection speed bonus
    --
    -- Formula is ~1.5% faster per level, rounded.
    -- Level 0 = 0%, Level 10 ≈ 15%.
    -- We show this first, always (even at level 0), as:
    --   "8% Faster Track Inspection"
    ---------------------------------------------------------
    local speedBonusPct = math.floor((lvl * 1.5) + 0.5)
    if speedBonusPct > 0 then
        ctx.add(ST.getText("IGUI_DST_Tracking_val_Speed", speedBonusPct))
    end

    ---------------------------------------------------------
    -- 2) Cumulative capability unlocks
    --
    -- Order matters. We always add from lowest milestone
    -- to highest, but we only include milestones the
    -- current level actually qualifies for.
    --
    -- Milestones / thresholds:
    --   >=1  Small Game Tracking        (rabbits etc.)
    --   >=4  Large Game Tracking        (deer etc.)
    --   >=5  Species Identification     (shows exact animal)
    --   >=9  Behavior Interpretation    (feeding vs moving)
    --   >=10 Master Tracker             (all spoor types)
    ---------------------------------------------------------

    -- Game Tracking
    if lvl >= 1 then
        ctx.addHeader(ST.getText("IGUI_DST_Tracking_hdr"))
        ctx.add(ST.getText("IGUI_DST_Tracking_val_SmallGame"))
    end

    if lvl >= 4 then
        ctx.add(ST.getText("IGUI_DST_Tracking_val_LargeGame"))
    end

    -- Advanced Tracking
    if lvl >= 5 then
        ctx.addHeader(ST.getText("IGUI_DST_Tracking_hdr_Advanced"))
        ctx.add(ST.getText("IGUI_DST_Tracking_val_SpeciesID"))
    end

    if lvl >= 9 then
        ctx.add(ST.getText("IGUI_DST_Tracking_val_Behavior"))
    end

    if lvl >= 10 then
        ctx.add(ST.getText("IGUI_DST_Tracking_val_Master"))
    end
end)

ST.addAutoLearnRecipes(KEY)
ST.addUnlockCraftRecipes(KEY)
ST.addUnlockBuildRecipes(KEY)